Shortcuts={};


//支持的按键
Shortcuts.KEYS = {};
Shortcuts.KEYS.F_KEYS = {
	"112":"F1",
	"113":"F2",
	"114":"F3",
	"115":"F4",
	"116":"F5",
	"117":"F6",
	"118":"F7",
	"119":"F8",
	"120":"F9",
	"121":"F10",
	"122":"F11",
	"123":"F12"
};

Shortcuts.KEYS.LETTERS_NUMS = {
	//主键盘数字：
	"48":"0",
	"49":"1",
	"50":"2",
	"51":"3",
	"52":"4",
	"53":"5",
	"54":"6",
	"55":"7",
	"56":"8",
	"57":"9",
	//主键盘字母：
	"65":"A",			
	"66":"B",			
	"67":"C",			
	"68":"D",			
	"69":"E",			
	"70":"F",			
	"71":"G",			
	"72":"H",			
	"73":"I",		
	"74":"J",
	"75":"K",
	"76":"L",
	"77":"M",
	"78":"N",
	"79":"O",
	"80":"P",
	"81":"Q",
	"82":"R",
	"83":"S",
	"84":"T",
	"85":"U",
	"86":"V",
	"87":"W",
	"88":"X",
	"89":"Y",
	"90":"Z"
};

Shortcuts.KEYS.NORMAL_KEYS ={
	"32":"Space",
	//方向键：
	"37":"&#8592",
	"38":"&#8593",
	"39":"&#8594",
	"40":"&#8595",
	//主键盘数字：
	"48":"0",
	"49":"1",
	"50":"2",
	"51":"3",
	"52":"4",
	"53":"5",
	"54":"6",
	"55":"7",
	"56":"8",
	"57":"9",
	//主键盘字母：
	"65":"A",			
	"66":"B",			
	"67":"C",			
	"68":"D",			
	"69":"E",			
	"70":"F",			
	"71":"G",			
	"72":"H",			
	"73":"I",		
	"74":"J",
	"75":"K",
	"76":"L",
	"77":"M",
	"78":"N",
	"79":"O",
	"80":"P",
	"81":"Q",
	"82":"R",
	"83":"S",
	"84":"T",
	"85":"U",
	"86":"V",
	"87":"W",
	"88":"X",
	"89":"Y",
	"90":"Z",
	//小键盘区：
	"96":"Num 0",			
	"97":"Num 1",			
	"98":"Num 2",			
	"99":"Num 3",			
	"100":"Num 4",			
	"101":"Num 5",			
	"102":"Num 6",					
	"103":"Num 7",	
	"104":"Num 8",	
	"105":"Num 9",
	"106":"Num *",
	"107":"Num +",
	"109":"Num -",
	"111":"Num /",
	//标点符号：
	"186":";",
	"187":"=",
	"188":",",
	"189":"-",
	"190":".",
	"191":"/",
	"192":"`",
	"219":"[",
	//"220":"\\",
	"221":"]",
	"222":"'",
	//其他：
	"33":"PgUp",
	"34":"PgDn",
	"35":"End",
	"36":"Home",
	"45":"Insert"
};

Shortcuts.KEYS.COMBO_KEYS ={
	"16":"Shift",
	"17":"Ctrl",
	"18":"Alt"
};

Shortcuts.KEYS.FUNCTION_KEYS = {
	"8":"BackSpace",

	"27":"Esc",

	"46":"Delete",
	"110":"Del",

	"13":"Enter",
	"108":"Enter*"
};

//支持的快捷键格式
Shortcuts.VALID_SHORTCUTS = [
	["f_key"],

	["Ctrl","normal_key"],
	["Shift","normal_key"],
	["Alt", "normal_key"],
	["Ctrl","f_key"],
	["Shift","f_key"],
	["Alt", "f_key"],	

	["Ctrl","Shift", "normal_key"],
	["Ctrl","Alt", "normal_key"],
	["Shift","Alt", "normal_key"],
	["Ctrl","Shift", "f_key"],
	["Ctrl","Alt", "f_key"],
	["Shift","Alt", "f_key"],

	["Ctrl","Shift","Alt","normal_key"],
	["Ctrl","Shift","Alt","f_key"]
];

//支持的快捷键
Shortcuts.SHORTCUTS ={
	"Acc_New_Tab":	"新建标签页",
	"Acc_New_Window":	"新建窗口",
	"Acc_SaveWebAS":	"当前页另存为文件",
	"Acc_Find":	"网页内查找",
	"Acc_History":	"历史记录",
	"Acc_Open":	"打开文件",
	"Acc_CloseCurrentTab":	"关闭当前标签页",
	"Acc_SwitchRightTab":	"向右切换标签",
	"Acc_SwitchLeftTab":	"向左切换标签",
	"Acc_Home":	"主页",
	"Acc_Backward":	"后退",
	"Acc_Forword":	"前进",
	"Acc_RestoreLastClose":	"恢复上次关闭页面",
	"Acc_OfficialWeb":	"QQ浏览器官方网站",
	"Acc_Config":	"选项",
	"Acc_AddressBar_DropDown":	"地址栏下拉",
	"Acc_AddressBar_SelAll":	"选中地址栏中的文字",
	"Acc_AddressBar_Set_Focus":	"定位到地址栏",
	"Acc_Refresh":	"当前页面刷新",
	"Acc_Mute":	"页面静音控制",
	"Acc_Stop_Load":	"停止当前页面加载",
	"Acc_Show_Fav_Bar": "显示/隐藏收藏栏",
	"Acc_Print": "打印",
	"Acc_Full_Screen": '全屏快捷键',

	"{8A23D958-AF26-42f8-911E-04D5030CB33D}_a_1":	"截屏",
	"{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}_a1":	"当前页添加到收藏夹",
	"Acc_Organize_Fav":         "整理收藏夹 ",
	"{D21B044A-3FDF-4241-865C-5692771BED80}_a_6":	"恢复页面到原始大小",
	"{D21B044A-3FDF-4241-865C-5692771BED80}_a_1":	"页面放大20%",
	"{D21B044A-3FDF-4241-865C-5692771BED80}_a_2":	"页面缩小20%",
	"Acc_Zoom_By_Mouse":	"直接缩放页面",

	"Acc_Text_Select_All":	"全选",
	"Acc_Text_Copy":	"复制",
	"Acc_Text_Cut":	"剪切",
	"Acc_Text_Paste":	"粘贴",
	"Acc_Quit_Browser":	"退出QQ浏览器"
};

Shortcuts.HOTKEYS = {
	"BossHotKey":	"老板键",
	"{8A23D958-AF26-42f8-911E-04D5030CB33D}_h_1":"截屏热键"
};

Shortcuts.init = function(){
	if(qqbrowser){
		var get_hotkey = function(sc_data){
			sc_data = unescape(sc_data);
			sc_data = eval('('+sc_data+')'); 
			var data = {
				"shortcuts" : null,
				"hotkeys" : null
			};

			if(sc_data[0]){
				data["shortcuts"] = sc_data[1];
			
				var start_init_container = function(hk_data){
					hk_data = unescape(hk_data);
					hk_data = eval('('+hk_data+')');
					if(hk_data[0]){
						data["hotkeys"] = hk_data[1];

						//初始化界面
						Shortcuts.init_container(data);

						//初始化事件处理函数
						Shortcuts.Events.init(data);

					}
				};

				qqbrowser.hotkey.getHotkeyConfig(start_init_container);
			}

		};
		qqbrowser.accelerator.getAcceleratorConfig(get_hotkey);
	}
};

/*获取一个key的css类型，返回：modifier、normal*/
Shortcuts.get_key_type = function(name){
	for(item in Shortcuts.KEYS.NORMAL_KEYS){
		if(name === Shortcuts.KEYS.NORMAL_KEYS[item]){
			return "normal";
		}
	}

	return "modifier";
};


//定义事件响应

var log = function(str){

	var logger = document.getElementById("log");
	logger.innerHTML += str + "<br/>";

};
Shortcuts.Events = {};
Shortcuts.Events.init = function(data){

	//输入的快捷键组合
	var inputs = {};
	inputs.codes = [];
	inputs.keys = [];
	inputs.types = [];
	inputs.released = [];

	//校验逻辑
	var check_key = function(key_code){

		if(key_code in Shortcuts.KEYS.COMBO_KEYS){
			inputs.codes.push(key_code);
			inputs.keys.push(Shortcuts.KEYS.COMBO_KEYS[key_code]);
			inputs.types.push(Shortcuts.KEYS.COMBO_KEYS[key_code]);
			inputs.released.push(false);
		}else if(key_code in Shortcuts.KEYS.F_KEYS){
			inputs.codes.push(key_code);
			inputs.keys.push(Shortcuts.KEYS.F_KEYS[key_code]);
			inputs.types.push("f_key");
			inputs.released.push(false);
		}else if(key_code in Shortcuts.KEYS.NORMAL_KEYS){
			inputs.codes.push(key_code);
			inputs.keys.push(Shortcuts.KEYS.NORMAL_KEYS[key_code]);
			inputs.types.push("normal_key");
			inputs.released.push(false);
		}else{
			return false;
		}

		return true;
	};

	var check_input = function(){
		//var logger = document.getElementById("log");

		var b_valid = false;

		var input_length = inputs.codes.length;
		if( input_length > 4){
			return false;
		}

		var adjust_inputs = function(){
			var b_all_combo_keys = true;
			for(var i=0;i<input_length;i++){
				if(!(inputs.codes[i] in Shortcuts.KEYS.COMBO_KEYS)){
					// 增加只输入一个字母键或者数字键的应用场景
					if (input_length === 1 && inputs.codes[i] in Shortcuts.KEYS.LETTERS_NUMS) {
						// 自动加入Ctrl和Alt键
						inputs.codes.unshift(18);
						inputs.keys.unshift('Alt');
						inputs.types.unshift('Alt');
						inputs.released.unshift(true);
						inputs.codes.unshift(17);
						inputs.keys.unshift('Ctrl');
						inputs.types.unshift('Ctrl');
						inputs.released.unshift(true);
						break;
					}
					b_all_combo_keys = false;
					return;
				}
			}

			var compare_keys = function(key1, key2){
				var b_bigger = false;
				if(key1 === "Ctrl"){
					b_bigger = true;
				}
				if(key1 === "Shift" && key2 === "Alt"){
					b_bigger = true;
				}

				return b_bigger;
			};

			var bubble_sort = function(){
				var b_switched = false;

				for(var i=0;i<input_length-1;i++){
					
					if(!compare_keys(inputs.keys[i], inputs.keys[i+1])){
						var tmp_code = inputs.codes[i+1];
						var tmp_key = inputs.keys[i+1];
						var tmp_type = inputs.types[i+1];
						var tmp_released = inputs.types[i+1];

						inputs.codes[i+1] = inputs.codes[i];
						inputs.keys[i+1] = inputs.keys[i];
						inputs.types[i+1] = inputs.types[i];
						inputs.released[i+1] = inputs.released[i];

						inputs.codes[i] = tmp_code;
						inputs.keys[i] = tmp_key;
						inputs.types[i] = tmp_type;
						inputs.released[i] = tmp_released;

						b_switched = true;
					}
				}

				//logger.innerHTML += ("result:" + inputs.keys.join(",") + "<br/>");
				return b_switched;
			};

			if(b_all_combo_keys){
				if(bubble_sort()){
					bubble_sort();
				}
			}
		};
		adjust_inputs();

		var count = Shortcuts.VALID_SHORTCUTS.length;
		for(var i=0;i<count;i++){
			var valid_input = Shortcuts.VALID_SHORTCUTS[i];

			//log.innerHTML += "check if valid input:" + valid_input.join(",") + "<br/>";
			var valid_input_length = valid_input.length;
			if(input_length <= valid_input_length){
				for(var j=0;j<input_length;j++){
					//log.innerHTML += "type:" +inputs.types[j] + "<br/>";
					if(inputs.types[j] !== valid_input[j]){
						break;
					}else{
						if(j === (input_length-1)){
							b_valid = true;
						}
					}
				}
			}

			if(b_valid){
				break;
			}
		}

		return b_valid;
	};

	var check_if_conflict = function(){
		var shortcut_str = inputs.keys.join("+");

		var hotkeys = data["hotkeys"];
		var hk_count = hotkeys.length;
		for(var i=0;i<hk_count;i++){
			if(shortcut_str === hotkeys[i]["key"]){
				return true;
			}
		}

		var shortcuts = data["shortcuts"];
		var sc_count = shortcuts.length;
		for(var i=0;i<sc_count;i++){
			if(shortcut_str === shortcuts[i]["key"]){
				return true;
			}
		}

		return false;
	};

	var check_shortcut = function(cell_input){
		var b_valid = false;
		var cell = cell_input.parentNode;

		var input_length = inputs.codes.length;
		if( input_length > 4){
			return false;
		}

		if(check_if_conflict()){
			cell.className = "sc_cell conflict";
			cell_input.style.visibility = "visible";
			cell_input.focus();
			
		}else{
			//cell.className = "sc_cell active";
		}

		var count = Shortcuts.VALID_SHORTCUTS.length;
		for(var i=0;i<count;i++){
			var valid_input = Shortcuts.VALID_SHORTCUTS[i];

			var valid_input_length = valid_input.length;
			if(input_length === valid_input_length){
				for(var j=0;j<input_length;j++){
					if(inputs.types[j] !== valid_input[j]){
						break;
					}else{
						if(j === (input_length-1)){
							b_valid = true;
						}
					}
				}
			}

			if(b_valid){
				break;
			}
		}

		return b_valid;
	};

	
	var show_keys = function(cell_input){
		var length = inputs.codes.length;
		
		var str = "";
		if( length === 1 && inputs.types[0]==="f_key"){
			str = "<div class='sc_key_modifier'>" + inputs.keys[0] + "</div>";
		}else{
			
			for(var i=0;i<length;i++){
				var type = inputs.types[i];
				var key = inputs.keys[i];
				if( type === "Ctrl" || type === "Shift" || type === "Alt" ){
					str += "<div class='sc_key_modifier'>" + key + "</div><div class='sc_key_plus'>+</div>";
				}else{
					if( type === "f_key" ){
						str += "<div class='sc_key_modifier'>" + key + "</div>";
					}

					if( type === "normal_key" ){
						str += "<div class='sc_key_normal'>" + key + "</div>";
					}
				}
			}
		}
		
		var cell = cell_input.parentNode;
		cell.className = "sc_cell active";
		var cell_keys = cell.firstChild;
		cell_keys.innerHTML = str;
		cell_keys.style.display = "";
	};
	
	var del_last_key = function(){
		var length = inputs.codes.length;
		if(length >= 1){
			inputs.codes.pop();
			inputs.keys.pop();
			inputs.types.pop();
			inputs.released.pop();
		}
	};



	var clear_inputs = function(){
		inputs = {};
		inputs.codes = [];
		inputs.keys = [];
		inputs.types = [];
		inputs.released = [];
	};

	var resort_keys = function(sc_keys_str, cell_input){
		// 修正'+'号无法正常显示的问题
		var endPlus = '';
		if (sc_keys_str[sc_keys_str.length - 1] === "+") { 
			sc_keys_str = sc_keys_str.substring(0, sc_keys_str.length - 1);
			endPlus = '+';
		}
		var sc_keys = sc_keys_str.split("+");
		var key_count = sc_keys.length;
		
		var keys_str = "";
		for(var i=0;i<key_count;i++){
			var key = sc_keys[i];
			if (i === key_count - 1) {
				key = key + endPlus;
			}
			var type = Shortcuts.get_key_type(key);
			
			if(type==="modifier"){
				if(key ==="Ctrl"||key==="Shift"||key==="Alt"){
					keys_str += "<div class='sc_key_modifier'>" + key + "</div><div class='sc_key_plus'>+</div>";
				} else if ( key === "NULL") {
						keys_str = '';
				} else {
					keys_str += "<div class='sc_key_modifier'>" + key + "</div>";
				}
			} else {
				keys_str +=  "<div class='sc_key_normal'>" + key + "</div>";
			}
		}

		var cell_keys = cell_input.parentNode.firstChild;
		cell_keys.innerHTML = keys_str;
		cell_keys.style.display = "";
	};

	// 改变sc_keys的显示
	var change_sc_keys = function(cell, status) {
		if (!cell)
			return;
		
		var sc_keys = cell.firstChild;
		var cell_input = sc_keys.nextSibling;
		
		if (!sc_keys) 
			return;
		
		if (status) {
			sc_keys.style.opacity = 1;
		} else {
			sc_keys.style.opacity = 0.5;
			cell_input.style.position = 'absolute';
		}
		
	}
	
	//事件出口
	var on_click_cell = function(event, cell){
		cell.className = "sc_cell active";
		var cell_input = cell.getElementsByTagName("input")[0];
		var previous = cell_input.previousSibling;
		
		cell_input.style.visibility = "visible";
		cell_input.value = "";
		change_sc_keys(cell, false);
		
		//qqbrowser.hotkey.disableHotkey(function() {});
		qqbrowser.accelerator.disableAccelerator(function() {});
		
		
		cell_input.focus();
	};
	Shortcuts.Events.on_click_cell = on_click_cell;
	
	// 处理默认的粘贴事件
	var on_paste_input = function(event, cell_input) {
		event.preventDefault();
	};
	Shortcuts.Events.on_paste_input = on_paste_input;

	var on_keydown_input = function(event, cell_input){
		// 解决出现input输入框后可以输入字符的问题
		event.preventDefault();
		cell_input.style.position = '';
		change_sc_keys(cell_input.parentNode, true);
		var key_code = event.keyCode;
		//log("onkeydown:" + key_code);
		if(key_code in Shortcuts.KEYS.FUNCTION_KEYS){
			if(key_code === 8 || key_code === 46 || key_code ===110){
				var cell_keys = cell_input.parentNode.firstChild;
				cell_keys.style.display = "none";

				clear_inputs();
			}else if(key_code === 27){
				var type_index = cell_input.id.lastIndexOf("_");
				var key_type = cell_input.id.substring(type_index+1);
				var key_id = cell_input.id.substring(0, type_index);
				var old_sc_str = "";

				if(key_type === "hotkeys"){
					old_sc_str = data["hotkeys"][key_id]["key"];
				}else{
					old_sc_str = data["shortcuts"][key_id]["key"];
				}
				
				resort_keys(old_sc_str, cell_input);
				clear_inputs();
				
				// 样式还原
				var cell = cell_input.parentNode;
				cell.className = "sc_cell";
			}else{
				cell_input.blur();
			}
		}else{
			//log.innerHTML += key_code  +  "<br/>";
			//判断key是否重复，重复key不做处理
			var length = inputs.codes.length;

			for(var i=0;i<length;i++){
				if(inputs.codes[i] === key_code){
					return false;
				}
			}
			
			//判断key是否合法，非法key不处理，合法加入inputs
			var b_valid_key = check_key(key_code);
			
			
			if(b_valid_key){
				//判断整个输入串是否合法，非法给出提示
				var b_valid_input = check_input();
				
				if(b_valid_input){
					
					show_keys(cell_input);

					//log.innerHTML += "right:"+inputs.keys.join(",") + "<br/>";
				}else{
					del_last_key();

					//log.innerHTML += "wrong:"+inputs.keys.join(",") + "&nbsp;&nbsp;" + inputs.types.join(",") + "<br/>";
				}
			}else{
				//log.innerHTML += "invalid key" + "<br/>";
			}
		}

		//log("onkeydown:" + inputs.keys.join(","));
		
		return false;
	};
	Shortcuts.Events.on_keydown_input = on_keydown_input;

	var on_keyup_input = function(event, cell_input){

		var key_code = event.keyCode;
		//log("onkeyup:" + key_code);
		
		var length = inputs.codes.length;
		for(var i=0;i<length;i++){
			if(inputs.codes[i] === key_code){
				inputs.released[i] = true;
			}
		}

		var check_if_released_shortcut = function(){
			
			if(length > 0){
				for(var i=0;i<length;i++){
					if(inputs.released[i] === false){
						return false;
					}
				}
			}else{
				return false;
			}

			return true;
		};

		if(check_if_released_shortcut()){
			var length = inputs.codes.length;
			var cell = cell_input.parentNode;

			if(length === 0){
				var cell_keys = cell_input.parentNode.firstChild;
				if(cell_keys.style.display === "none"){
					cell_keys.style.display = "";
				}
			}else{
				var b_valid = check_shortcut(cell_input);

				var type_index = cell_input.id.lastIndexOf("_");
				var key_type = cell_input.id.substring(type_index+1);
				var key_id = cell_input.id.substring(0, type_index);

				if(b_valid){
					var old_sc_str = "";
					var new_sc_str = inputs.keys.join("+");
					if(key_type === "hotkeys"){
						old_sc_str = data["hotkeys"][key_id]["key"];

						var change_hotkey_callback = function(cb_data){
							cb_data = eval(cb_data);

							if(cb_data[0]){		//修改成功
								Shortcuts.save_alert();

								cell_input.style.visibility = "hidden";
								data["hotkeys"][key_id]["key"] = new_sc_str;
								clear_inputs();
								cell_input.blur();
							}else{
								if(cb_data[1] === 2){	//快捷键冲突
									cell.className = "sc_cell conflict";
									cell_input.style.visibility = "visible";
									// 清空当前的冲突输入，以便让其重新输入
									clear_inputs();
									cell_input.focus();
									change_sc_keys(cell_input.parentNode, false);
								} else if( cb_data[1] === 1 ){	//快捷键失败
									cell.className = "sc_cell fail";
									cell_input.style.visibility = "visible";
									// 清空当前的失败输入，以便让其重新输入
									clear_inputs();
									cell_input.focus();
									change_sc_keys(cell_input.parentNode, false);
								}
							}
						};
						
						qqbrowser.hotkey.changeHotkeyById(key_id, old_sc_str, new_sc_str, change_hotkey_callback);
						
						
					}else{
						old_sc_str = data["shortcuts"][key_id]["key"];

						var change_shortcut_callback = function(cb_data){
							cb_data = eval(cb_data);
							if(cb_data[0]){		//修改成功
								Shortcuts.save_alert();

								cell_input.style.visibility = "hidden";
								data["shortcuts"][key_id]["key"] = new_sc_str;
								clear_inputs();
								cell_input.blur();
								// 如果是按键释放并生效的形式，必须是设置生效才恢复快捷键的功能
								qqbrowser.accelerator.enableAccelerator(function() {});
							}else{
								if(cb_data[1] === 2){	//快捷键冲突
									cell.className = "sc_cell conflict";
									cell_input.style.visibility = "visible";
									// 清空当前的冲突输入，以便让其重新输入
									clear_inputs();
									cell_input.focus();
									change_sc_keys(cell_input.parentNode, false);
								} else if( cb_data[1] === 1 ){	//快捷键失败
									cell.className = "sc_cell fail";
									cell_input.style.visibility = "visible";
									// 清空当前的失败输入，以便让其重新输入
									clear_inputs();
									cell_input.focus();
									change_sc_keys(cell_input.parentNode, false);
								}
							}
						};

						qqbrowser.accelerator.changeAcceleratorById(key_id, old_sc_str, new_sc_str, change_shortcut_callback);
					}
					
					
					//qqbrowser.hotkey.enableHotkey(function() {});
					
					
				}else{
					
					var old_sc_str = "";
					if(key_type === "hotkeys"){
						old_sc_str = data["hotkeys"][key_id]["key"];
					}else{
						old_sc_str = data["shortcuts"][key_id]["key"];
					}
					
					resort_keys(old_sc_str, cell_input);
					clear_inputs();
					cell_input.blur();
				}
			}

			var cell = cell_input.parentNode;
			cell.className = "sc_cell";		
			

		}

		//log("onkeyup:" + inputs.keys.join(","));
		event.preventDefault();
		return false;
		
	};
	Shortcuts.Events.on_keyup_input = on_keyup_input;

	var on_blur_input = function(event, cell_input){
		var length = inputs.codes.length;
		var cell = cell_input.parentNode;

		change_sc_keys(cell_input.parentNode, true);
		var b_valid = check_shortcut(cell_input);
		
		// 清空快捷键输入的应用场景
		if ( length === 0) { // 快捷键输入为空
			var cell_keys = cell_input.parentNode.firstChild;
			if(cell_keys.style.display === "none"){ // 不进行显示表示设置时删除了快捷键设置
				b_valid = true;
			}
		}

		var type_index = cell_input.id.lastIndexOf("_");
		var key_type = cell_input.id.substring(type_index+1);
		var key_id = cell_input.id.substring(0, type_index);

		if(b_valid){
			var old_sc_str = "";
			var new_sc_str = "";
			
			// 如果此时输入为空，那么表示为清除快捷键设置的应用场景
			if (length === 0) {
				new_sc_str = "NULL"
			} else {
				new_sc_str = inputs.keys.join("+");
			}
			
			if(key_type === "hotkeys"){
				old_sc_str = data["hotkeys"][key_id]["key"];

				var change_hotkey_callback = function(cb_data){
				
					cb_data = eval(cb_data);
					
					if(cb_data[0]){		//修改成功
						Shortcuts.save_alert();

						cell_input.style.visibility = "hidden";
						data["hotkeys"][key_id]["key"] = new_sc_str;
						clear_inputs();
					}else{
						if(cb_data[1] === 2){	//快捷键冲突
							// cell.className = "sc_cell conflict";
							// cell_input.style.visibility = "visible";
							// cell_input.focus();
							// Modified by littleli 冲突确认或失焦点时还原原来的数据
							var old_sc_str = "";
							if(key_type === "hotkeys"){
								old_sc_str = data["hotkeys"][key_id]["key"];
							}else{
								old_sc_str = data["shortcuts"][key_id]["key"];
							}
				
							resort_keys(old_sc_str, cell_input);
							clear_inputs();
						}
					}
				};
				
				qqbrowser.hotkey.changeHotkeyById(key_id, old_sc_str, new_sc_str, change_hotkey_callback);
				
				
			}else{
				old_sc_str = data["shortcuts"][key_id]["key"];

				var change_shortcut_callback = function(cb_data){
					console.info(">>>>>>>>>>>>>>>>>>>>> cb_data:", cb_data);
					cb_data = eval(cb_data);
					if(cb_data[0]){		//修改成功
						Shortcuts.save_alert();

						cell_input.style.visibility = "hidden";
						data["shortcuts"][key_id]["key"] = new_sc_str;
						clear_inputs();
					}else{
						if(cb_data[1] === 2){	//快捷键冲突
						// cell.className = "sc_cell conflict";
						// cell_input.style.visibility = "visible";
						// cell_input.focus();
						// Modified by littleli 冲突确认或失焦点时还原原来的数据
							var old_sc_str = "";
							if(key_type === "hotkeys"){
								old_sc_str = data["hotkeys"][key_id]["key"];
							}else{
								old_sc_str = data["shortcuts"][key_id]["key"];
							}
				
							resort_keys(old_sc_str, cell_input);
							clear_inputs();
						}
					}
				};
				console.info(">>>>>>>>>>>>>>>>>>>>>>>> new_sc_str:", new_sc_str);
				qqbrowser.accelerator.changeAcceleratorById(key_id, old_sc_str, new_sc_str, change_shortcut_callback);
			}
			/*
			qqbrowser.hotkey.enableHotkey(callback);
			qqbrowser.accelerator.enableAccelerator(callback);
			*/
		}else{

			var old_sc_str = "";
			if(key_type === "hotkeys"){
				old_sc_str = data["hotkeys"][key_id]["key"];
			}else{
				old_sc_str = data["shortcuts"][key_id]["key"];
			}
			
			resort_keys(old_sc_str, cell_input);
			clear_inputs();
			//cell_input.focus();
		}

		
		//qqbrowser.hotkey.enableHotkey(function() {});
		qqbrowser.accelerator.enableAccelerator(function() {});
		
		var cell = cell_input.parentNode;
		cell.className = "sc_cell";
	};
	Shortcuts.Events.on_blur_input = on_blur_input;



};

Shortcuts.Events.on_reset = function(event){

	if(qqbrowser){
		var reset_hotkey = function(sc_data){
			sc_data = unescape(sc_data);
			sc_data = eval('('+sc_data+')'); 
			var data = {
				"shortcuts" : null,
				"hotkeys" : null
			};

			if(sc_data[0]){
				data["shortcuts"] = sc_data[1];
			
				var start_init_container = function(hk_data){
					hk_data = unescape(hk_data);
					hk_data = eval('('+hk_data+')');
					if(hk_data[0]){
						data["hotkeys"] = hk_data[1];
						
						// Modified by littleli
						// 解决当选中其他子面面恢复所有默认时，快捷键不恢复默认的问题
						var shortCutKey = $('#shortcutkey');
						if (shortCutKey.hasClass('selected')) {
							//初始化界面
							Shortcuts.init_container(data);
						}
						
						// 恢复成功提示
						Shortcuts.save_alert(true);
						
						//初始化事件处理函数
						Shortcuts.Events.init(data);
					}
				};
				qqbrowser.hotkey.resetHotkeyConfig(start_init_container);
			}

		};
		qqbrowser.accelerator.resetAcceleratorConfig(reset_hotkey);
	}
};



//初始化界面
Shortcuts.init_container = function(data){

	var option_contaier = document.getElementById('option-shortcutkey');
    option_contaier.style.display="";
	
	var container=document.getElementById('sc_container');
	container.innerHTML = "";
	
	//定义添加方法
		//添加表头
	var add_title = function(title){
		var str = "<div class='sc_title_row'>" + title + "</div>";
		container.innerHTML += str;
	};
	
		//添加行
	var add_row = function(key_type, id, sc_info){

		var sc_name = "";
		if(key_type === "hotkeys"){
			if(Shortcuts.HOTKEYS[id]){
				sc_name = Shortcuts.HOTKEYS[id];
			}
		}else{
			if(Shortcuts.SHORTCUTS[id]){
				sc_name = Shortcuts.SHORTCUTS[id];
			}
		}
		if(sc_name === ""){		//id-des.txt中没有，不处理
			return;
		}

		var b_can_modify = sc_info["canModify"];
		
		var sc_keys_str = sc_info["key"];
		console.info(sc_keys_str);
		// 修正'+'号无法正常显示的问题
		var endPlus = '';
		if (sc_keys_str[sc_keys_str.length - 1] === "+") { 
			sc_keys_str = sc_keys_str.substring(0, sc_keys_str.length - 1);
			endPlus = '+';
		}
		sc_keys_str = sc_keys_str.split('+');
		console.info(sc_keys_str);

		var keys_str = "";
		var key_count = sc_keys_str.length;

		for(var i=0;i<key_count;i++){
			var key = sc_keys_str[i];
			if (i === key_count - 1) {
				key = key + endPlus;
			}
			
			var type = Shortcuts.get_key_type(key);

			if(type==="modifier"){
				if(key ==="Ctrl"||key==="Shift"||key==="Alt"){
					keys_str += "<div class='sc_key_modifier'>" + key + "</div><div class='sc_key_plus'>+</div>";
				}else{
					if(key === "鼠标滚轮"){
						keys_str += "<div class='sc_key_text'>" + key + "</div>";
					} else if ( key === "NULL") {
						keys_str = '';
					} else {
						keys_str += "<div class='sc_key_modifier'>" + key + "</div>";
					}
				}
			}else{
				keys_str +=  "<div class='sc_key_normal'>" + key + "</div>";
			}
		}

		var str = "";
		if(b_can_modify){
			str ="<div id='" + id + "' class='sc_row'>"+
					"<div class='sc_def'>" + sc_name + "</div>"+
					"<div class='sc_cell' onclick='Shortcuts.Events.on_click_cell(event,this)'>"+
						"<div class='sc_keys'>"+
							keys_str + 
						"</div>"+
						"<input id='" + id + "_" + key_type +"' onpaste='Shortcuts.Events.on_paste_input(event, this);' onkeydown='Shortcuts.Events.on_keydown_input(event, this);' onkeyup='Shortcuts.Events.on_keyup_input(event, this);' onblur='Shortcuts.Events.on_blur_input(event,this)' " + 
						"style='position: absolute; left: 3px; top: 0px;visibility:hidden;margin-top:4px;margin-left:0px;padding-left:0px;-webkit-border-radius:0;width:20px; height:20px; line-height:20px; border:0px solid red; background:transparent;outline:none;' type='text'/>"+
					"</div>"+
				"</div>";
		}else{
			str ="<div id='" + id + "' class='sc_row'>"+
					"<div class='sc_def'>" + sc_name + "</div>"+
					"<div class='sc_cell disabled'>"+
						"<div class='sc_keys'>"+
							keys_str + 
						"</div>"+
					"</div>"+
				"</div>";
		}
		container.innerHTML += str;
	};




	//添加
	add_title("热键");
	
	var hotkeys = data["hotkeys"];
	for(item in hotkeys){
		add_row("hotkeys", item, hotkeys[item]);	
	}

	var shortcuts = data["shortcuts"];
	add_title("浏览");
	add_row("shortcuts", "Acc_Stop_Load", shortcuts["Acc_Stop_Load"]);
	add_row("shortcuts", "Acc_AddressBar_SelAll", shortcuts["Acc_AddressBar_SelAll"]);
	add_row("shortcuts", "Acc_Forword", shortcuts["Acc_Forword"]);
	add_row("shortcuts", "Acc_Backward", shortcuts["Acc_Backward"]);
	add_row("shortcuts", "Acc_Home", shortcuts["Acc_Home"]);
	add_row("shortcuts", "Acc_RestoreLastClose", shortcuts["Acc_RestoreLastClose"]);
	add_row("shortcuts", "Acc_Full_Screen", shortcuts["Acc_Full_Screen"]);
	add_row("shortcuts", "Acc_AddressBar_DropDown", shortcuts["Acc_AddressBar_DropDown"]);
	add_row("shortcuts", "Acc_Refresh", shortcuts["Acc_Refresh"]);
	add_row("shortcuts", "Acc_AddressBar_Set_Focus", shortcuts["Acc_AddressBar_Set_Focus"]);
	add_row("shortcuts", "Acc_Zoom_By_Mouse", shortcuts["Acc_Zoom_By_Mouse"]);
	add_row("shortcuts", "{D21B044A-3FDF-4241-865C-5692771BED80}_a_6", shortcuts["{D21B044A-3FDF-4241-865C-5692771BED80}_a_6"]);
	add_row("shortcuts", "{D21B044A-3FDF-4241-865C-5692771BED80}_a_1", shortcuts["{D21B044A-3FDF-4241-865C-5692771BED80}_a_1"]);
	add_row("shortcuts", "{D21B044A-3FDF-4241-865C-5692771BED80}_a_2", shortcuts["{D21B044A-3FDF-4241-865C-5692771BED80}_a_2"]);
	add_row("shortcuts", "Acc_Mute", shortcuts["Acc_Mute"]);

	add_title("标签页");
	add_row("shortcuts", "Acc_New_Tab", shortcuts["Acc_New_Tab"]);
	add_row("shortcuts", "Acc_New_Window", shortcuts["Acc_New_Window"]);
	add_row("shortcuts", "Acc_CloseCurrentTab", shortcuts["Acc_CloseCurrentTab"]);
	add_row("shortcuts", "Acc_SwitchRightTab", shortcuts["Acc_SwitchRightTab"]);
	add_row("shortcuts", "Acc_SwitchLeftTab", shortcuts["Acc_SwitchLeftTab"]);

	add_title("工具");
	add_row("shortcuts", "Acc_Print", shortcuts["Acc_Print"]);
	add_row("shortcuts", "Acc_Open", shortcuts["Acc_Open"]);
	add_row("shortcuts", "Acc_History", shortcuts["Acc_History"]);
	add_row("shortcuts", "Acc_Config", shortcuts["Acc_Config"]);

	add_title("文本");
	add_row("shortcuts", "Acc_Text_Select_All", shortcuts["Acc_Text_Select_All"]);
	add_row("shortcuts", "Acc_Text_Copy", shortcuts["Acc_Text_Copy"]);
	add_row("shortcuts", "Acc_Text_Paste", shortcuts["Acc_Text_Paste"]);
	add_row("shortcuts", "Acc_Text_Cut", shortcuts["Acc_Text_Cut"]);
	add_row("shortcuts", "Acc_Find", shortcuts["Acc_Find"]);

	add_title("其他");
	add_row("shortcuts", "Acc_SaveWebAS", shortcuts["Acc_SaveWebAS"]);
	add_row("shortcuts", "{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}_a1", shortcuts["{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}_a1"]);
	add_row("shortcuts", "Acc_Organize_Fav", shortcuts["Acc_Organize_Fav"]);
	add_row("shortcuts", "Acc_Show_Fav_Bar", shortcuts["Acc_Show_Fav_Bar"]);
	add_row("shortcuts", "Acc_OfficialWeb", shortcuts["Acc_OfficialWeb"]);
	add_row("shortcuts", "Acc_Quit_Browser", shortcuts["Acc_Quit_Browser"]);

	//container.innerHTML += "<div id='log'></div>";
	
};


Shortcuts.save_alert = function(reset){
	var status=document.getElementById("save-status");
	//淡入淡出
	var val = 0.9;
	var speed = 200; // 这个控制速度 越大越慢,第一个fadein , 第二个fadeout ,可以设不同的值
	var holdontime = 800; // ms
	$(status).css("opacity",0);
	$(status).attr('innerText', '已自动保存');
	if (reset) {
		$(status).attr('innerText', '已恢复默认');
	}
	$(status).animate({opacity:'+='+val},speed,'linear',function(){
		setTimeout(function(){
			$(status).animate({opacity:'-='+val},speed);
		},holdontime);
	});	

};

